<?php
include 'koneksi.php';

$nis = isset($_POST['nis']) ? mysqli_real_escape_string($conn, $_POST['nis']) : '';
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Cek Pembayaran SPP - Siswa</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-[#F8FAFC] font-sans">

    <nav class="bg-[#1E293B] p-6 text-white text-center shadow-xl">
        <h1 class="text-xl font-bold tracking-tight">Portal Informasi Pembayaran Siswa</h1>
        <p class="text-xs text-slate-400 mt-1 uppercase tracking-widest">Silahkan masukkan NIS untuk melihat riwayat</p>
    </nav>

    <main class="container mx-auto p-6 max-w-4xl mt-10">
        
        <div class="bg-white p-8 rounded-[2.5rem] shadow-sm mb-8 border border-slate-200 text-center">
            <form action="" method="POST" class="flex flex-col md:flex-row gap-4 justify-center items-center">
                <input type="text" name="nis" value="<?php echo $nis; ?>" placeholder="Masukkan NIS Siswa..." required 
                       class="w-full md:w-80 border-2 border-slate-100 bg-slate-50 rounded-2xl px-6 py-4 outline-none focus:border-emerald-500 transition text-center font-bold text-lg">
                <button type="submit" class="bg-emerald-500 hover:bg-emerald-600 text-white px-10 py-4 rounded-2xl font-bold shadow-lg shadow-emerald-200 transition-all active:scale-95">
                    Cek Tagihan
                </button>
            </form>
        </div>

        <?php 
        if ($nis != '') {
            // Cari data siswa
            $data_siswa = mysqli_query($conn, "SELECT * FROM siswa WHERE nis = '$nis'");
            $s = mysqli_fetch_array($data_siswa);

            if ($s) { ?>
                <div class="bg-emerald-600 p-8 rounded-[2.5rem] text-white mb-6 shadow-xl flex justify-between items-center">
                    <div>
                        <p class="text-xs uppercase tracking-[0.2em] opacity-80">Nama Siswa</p>
                        <h2 class="text-2xl font-bold"><?php echo $s['nama_siswa']; ?></h2>
                        <p class="text-sm mt-1 opacity-80">Kelas: <?php echo $s['kelas']; ?></p>
                    </div>
                    <i class="fas fa-user-graduate text-5xl opacity-20"></i>
                </div>

                <div class="bg-white rounded-[2.5rem] shadow-sm overflow-hidden border border-slate-200">
                    <table class="w-full text-left">
                        <thead>
                            <tr class="bg-slate-50 text-[10px] uppercase text-slate-400 font-bold tracking-widest">
                                <th class="p-6">Tanggal</th>
                                <th class="p-6">Periode</th>
                                <th class="p-6 text-center">Metode</th> <th class="p-6 text-center">Status</th> <th class="p-6 text-right">Nominal</th>
                            </tr>
                        </thead>
                        <tbody class="text-sm divide-y divide-slate-50">
                            <?php
                            $id_siswa = $s['id'];
                            $query = mysqli_query($conn, "SELECT * FROM pembayaran WHERE id_siswa = '$id_siswa' ORDER BY tgl_bayar DESC");
                            
                            if (mysqli_num_rows($query) > 0) {
                                while($r = mysqli_fetch_array($query)) { ?>
                                    <tr class="hover:bg-slate-50 transition">
                                        <td class="p-6 text-slate-500"><?php echo date('d M Y', strtotime($r['tgl_bayar'])); ?></td>
                                        <td class="p-6 font-bold text-slate-700"><?php echo $r['periode']; ?></td>
                                        <td class="p-6 text-center italic text-slate-400"><?php echo $r['metode_bayar']; ?></td>
                                        
                                        <td class="p-6 text-center">
                                            <span class="bg-emerald-100 text-emerald-700 px-3 py-1 rounded-full text-[10px] font-bold uppercase tracking-wider">
                                                Lunas
                                            </span>
                                        </td>

                                        <td class="p-6 text-right font-bold text-emerald-600">Rp <?php echo number_format($r['jumlah_bayar'], 0, ',', '.'); ?></td>
                                    </tr>
                                <?php }
                            } else {
                                echo "<tr><td colspan='5' class='p-10 text-center text-slate-400 italic'>Belum ada riwayat pembayaran.</td></tr>";
                            } ?>
                        </tbody>
                    </table>
                </div>
            <?php } else { ?>
                <div class="bg-red-50 text-red-500 p-8 rounded-[2.5rem] text-center border border-red-100">
                    <i class="fas fa-exclamation-circle text-3xl mb-3"></i>
                    <p class="font-bold">NIS tidak ditemukan!</p>
                    <p class="text-xs opacity-70">Pastikan nomor yang Anda masukkan sudah benar.</p>
                </div>
            <?php } 
        } ?>
    </main>

    <footer class="text-center py-10 text-slate-400 text-[10px] uppercase tracking-[0.3em]">
        &copy; 2025 SPP Digital &bull; Student Information System
    </footer>
</body>
</html>