<?php 
include 'koneksi.php';

// 1. Ambil data statistik
$total_siswa = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as t FROM siswa"))['t'];

$check_pembayaran = mysqli_query($conn, "SHOW TABLES LIKE 'pembayaran'");
if(mysqli_num_rows($check_pembayaran) > 0) {
    $total_pemasukan = mysqli_fetch_assoc(mysqli_query($conn, "SELECT SUM(jumlah_bayar) as t FROM pembayaran"))['t'] ?? 0;
    $bayar_hari_ini = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as t FROM pembayaran WHERE tgl_bayar = CURDATE()"))['t'];
} else {
    $total_pemasukan = 0;
    $bayar_hari_ini = 0;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - SPP Digital</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-gray-100 font-sans text-gray-800">

    <nav class="bg-emerald-600 p-4 text-white shadow-md sticky top-0 z-50">
        <div class="container mx-auto flex justify-between items-center">
            <div class="flex items-center gap-3">
                <div class="bg-emerald-500 p-2 rounded-xl shadow-lg border border-emerald-400/30">
                    <i class="fas fa-wallet text-white text-lg"></i>
                </div>
                <h1 class="text-xl font-bold tracking-tight">ADMINISTRASI SEKOLAH</h1>
            </div>
            
            <div class="hidden md:flex gap-6 text-sm">
                <a href="index.php" class="bg-emerald-800 px-3 py-1 rounded">Dashboard</a>
                <a href="tambah_siswa.php" class="hover:text-emerald-200 transition">Data Siswa</a>
                <a href="bayar.php" class="hover:text-emerald-200 transition font-bold text-yellow-300">Transaksi Bayar</a>
                <a href="riwayat.php" class="hover:text-emerald-200 transition">Riwayat Laporan</a>
            </div>

            <a href="login.php" class="bg-orange-500 hover:bg-orange-600 px-4 py-1 rounded text-sm transition">Keluar</a>
        </div>
    </nav>

    <main class="container mx-auto p-6">
        
        <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-8 gap-4">
            <div>
                <h2 class="text-3xl font-extrabold text-gray-900">Dashboard</h2>
                <p class="text-gray-500">Selamat datang di Sistem Informasi Administrasi Sekolah.</p>
            </div>
            <div class="flex gap-2">
                <a href="bayar.php" class="bg-emerald-600 hover:bg-emerald-700 text-white px-5 py-2.5 rounded-xl shadow-lg text-sm flex items-center gap-2 transition-all active:scale-95">
                    <i class="fas fa-money-bill-wave"></i> Bayar SPP
                </a>
                <a href="tambah_siswa.php" class="bg-emerald-600 hover:bg-emerald-700 text-white px-5 py-2.5 rounded-xl shadow-lg text-sm flex items-center gap-2 transition-all active:scale-95">
                    <i class="fas fa-plus"></i> Tambah Siswa
                </a>
            </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-10">
            <div class="bg-white p-6 rounded-2xl shadow-sm border-l-4 border-purple-500 flex items-center gap-5">
                <div class="bg-purple-100 p-4 rounded-xl text-purple-600"><i class="fas fa-users fa-2x"></i></div>
                <div>
                    <p class="text-3xl font-bold"><?php echo $total_siswa; ?></p>
                    <p class="text-gray-400 text-xs font-bold uppercase tracking-widest">Total Siswa</p>
                </div>
            </div>

            <div class="bg-white p-6 rounded-2xl shadow-sm border-l-4 border-orange-400 flex items-center gap-5">
                <div class="bg-orange-100 p-4 rounded-xl text-orange-500"><i class="fas fa-wallet fa-2x"></i></div>
                <div>
                    <p class="text-2xl font-bold">Rp <?php echo number_format($total_pemasukan, 0, ',', '.'); ?></p>
                    <p class="text-gray-400 text-xs font-bold uppercase tracking-widest">Total Pemasukan</p>
                </div>
            </div>

            <div class="bg-white p-6 rounded-2xl shadow-sm border-l-4 border-emerald-400 flex items-center gap-5">
                <div class="bg-emerald-100 p-4 rounded-xl text-emerald-600"><i class="fas fa-calendar-check fa-2x"></i></div>
                <div>
                    <p class="text-3xl font-bold"><?php echo $bayar_hari_ini; ?></p>
                    <p class="text-gray-400 text-xs font-bold uppercase tracking-widest">Bayar Hari Ini</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden mb-10">
            <div class="p-5 border-b bg-gray-50 flex justify-between items-center">
                <h3 class="font-bold text-gray-700 flex items-center gap-2">
                    <i class="fas fa-receipt text-emerald-500"></i> Pembayaran Terbaru
                </h3>
                <a href="riwayat.php" class="text-emerald-600 text-xs font-bold hover:underline">Lihat Semua Riwayat →</a>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full text-left">
                    <thead>
                        <tr class="bg-gray-50 text-[10px] uppercase text-gray-400 font-bold tracking-widest border-b">
                            <th class="p-4">Tanggal</th>
                            <th class="p-4">NIS / Nama Siswa</th>
                            <th class="p-4">Jumlah</th>
                            <th class="p-4 text-center">Status</th>
                            <th class="p-4 text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="text-sm divide-y divide-gray-100">
                        <?php
                        $riwayat = mysqli_query($conn, "SELECT pembayaran.*, siswa.nama_siswa, siswa.nis 
                                                       FROM pembayaran 
                                                       JOIN siswa ON pembayaran.id_siswa = siswa.id 
                                                       ORDER BY id_pembayaran DESC LIMIT 5");
                        if(mysqli_num_rows($riwayat) > 0){
                            while($r = mysqli_fetch_array($riwayat)){ ?>
                                <tr class="hover:bg-emerald-50/50 transition">
                                    <td class="p-4 text-gray-500"><?php echo date('d/m/Y', strtotime($r['tgl_bayar'])); ?></td>
                                    <td class="p-4">
                                        <div class="font-bold text-gray-800"><?php echo $r['nama_siswa']; ?></div>
                                        <div class="text-[10px] text-gray-400"><?php echo $r['nis']; ?></div>
                                    </td>
                                    <td class="p-4 text-emerald-600 font-black">Rp <?php echo number_format($r['jumlah_bayar'], 0, ',', '.'); ?></td>
                                    <td class="p-4 text-center">
                                        <span class="bg-emerald-100 text-emerald-700 px-3 py-1 rounded-full text-[10px] font-bold uppercase">
                                            Lunas
                                        </span>
                                    </td>
                                    <td class="p-4 text-center">
                                        <div class="flex justify-center gap-2">
                                            <a href="cetak.php?id=<?php echo $r['id_pembayaran']; ?>" target="_blank" class="text-emerald-500 hover:text-emerald-700 p-2 transition" title="Cetak Kwitansi">
                                                <i class="fas fa-print"></i>
                                            </a>
                                            <a href="edit_pembayaran.php?id=<?php echo $r['id_pembayaran']; ?>" class="text-blue-500 hover:text-blue-700 p-2 transition" title="Edit Pembayaran">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <a href="hapus_pembayaran.php?id=<?php echo $r['id_pembayaran']; ?>" onclick="return confirm('Yakin ingin menghapus riwayat pembayaran ini?')" class="text-red-400 hover:text-red-600 p-2 transition" title="Hapus Pembayaran">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                        <?php } 
                        } else {
                            echo "<tr><td colspan='5' class='p-10 text-center text-gray-400 italic'>Belum ada transaksi pembayaran.</td></tr>";
                        } ?>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
            <div class="p-5 border-b bg-gray-50">
                <h3 class="font-bold text-gray-700 flex items-center gap-2">
                    <i class="fas fa-user-graduate text-emerald-500"></i> Manajemen Data Siswa
                </h3>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full text-left">
                    <thead>
                        <tr class="bg-gray-50 text-[10px] uppercase text-gray-400 font-bold tracking-widest border-b">
                            <th class="p-4">NIS</th>
                            <th class="p-4">Nama Lengkap</th>
                            <th class="p-4">Kelas</th>
                            <th class="p-4 text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="text-sm divide-y divide-gray-100">
                        <?php
                        $siswa = mysqli_query($conn, "SELECT * FROM siswa ORDER BY id DESC");
                        while($row = mysqli_fetch_array($siswa)){ ?>
                            <tr class="hover:bg-gray-50 transition">
                                <td class="p-4 text-emerald-600 font-bold"><?php echo $row['nis']; ?></td>
                                <td class="p-4 font-medium"><?php echo $row['nama_siswa']; ?></td>
                                <td class="p-4 text-gray-500"><?php echo $row['kelas']; ?></td>
                                <td class="p-4 text-center">
                                    <div class="flex justify-center gap-3">
                                        <a href="edit.php?id=<?php echo $row['id']; ?>" class="text-emerald-500 hover:text-emerald-700 p-2 hover:bg-emerald-50 rounded-lg transition" title="Edit Siswa">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <a href="hapus.php?id=<?php echo $row['id']; ?>" onclick="return confirm('Yakin ingin menghapus data ini?')" class="text-red-300 hover:text-red-500 p-2 hover:bg-red-50 rounded-lg transition" title="Hapus Siswa">
                                            <i class="fas fa-trash-alt"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>

    </main>

    <footer class="text-center py-10 text-gray-400 text-[10px] uppercase tracking-widest">
        &copy; 2025 SPP Digital System - Dashboard Edition
    </footer>

</body>
</html>