<?php 
include 'koneksi.php';

if (isset($_POST['proses_bayar'])) {
    $id_siswa     = $_POST['id_siswa'];
    $tgl_bayar    = date('Y-m-d'); 
    $jumlah_bayar = $_POST['jumlah_bayar'];

    $query = mysqli_query($conn, "INSERT INTO pembayaran (id_siswa, tgl_bayar, jumlah_bayar) VALUES ('$id_siswa', '$tgl_bayar', '$jumlah_bayar')");

    // Pastikan kolom total_bayar ada di tabel siswa Anda agar query ini tidak error
    mysqli_query($conn, "UPDATE siswa SET total_bayar = total_bayar + $jumlah_bayar WHERE id = '$id_siswa'");

    if ($query) {
        echo "<script>alert('Pembayaran Berhasil!'); window.location='index.php';</script>";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transaksi Pembayaran - SPP Digital</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-emerald-50 min-h-screen font-sans">

    <nav class="bg-emerald-600 p-4 text-white shadow-lg mb-10">
        <div class="container mx-auto flex justify-between items-center px-2">
            <div class="flex items-center gap-3">
                <div class="bg-emerald-500 p-2 rounded-xl shadow-md border border-emerald-400/30">
                    <i class="fas fa-wallet text-white text-lg"></i>
                </div>
                <div>
                    <h1 class="text-lg font-bold leading-none">SPP Digital</h1>
                    <span class="text-[10px] uppercase tracking-widest text-emerald-100">Transaksi Bayar</span>
                </div>
            </div>
            <a href="index.php" class="text-xs bg-emerald-800 hover:bg-emerald-900 px-4 py-2 rounded-lg transition-all flex items-center gap-2">
                <i class="fas fa-arrow-left"></i> Dashboard
            </a>
        </div>
    </nav>

    <div class="max-w-md mx-auto bg-white p-8 rounded-3xl shadow-xl border border-emerald-100">
        <div class="flex items-center gap-3 mb-6">
            <div class="bg-emerald-100 p-3 rounded-full text-emerald-600">
                <i class="fas fa-money-bill-wave text-xl"></i>
            </div>
            <h2 class="text-2xl font-bold text-gray-800">Input Pembayaran</h2>
        </div>
        
        <form action="" method="POST" class="space-y-5">
            <div>
                <label class="block text-xs font-bold text-emerald-700 uppercase tracking-widest mb-2 ml-1">Pilih Siswa</label>
                <select name="id_siswa" class="w-full p-3.5 border-2 border-gray-100 rounded-2xl focus:ring-4 focus:ring-emerald-50 focus:border-emerald-400 outline-none transition text-gray-700" required>
                    <option value="">-- Pilih Siswa --</option>
                    <?php 
                    $siswa = mysqli_query($conn, "SELECT * FROM siswa ORDER BY nama_siswa ASC");
                    while($s = mysqli_fetch_array($siswa)) {
                        echo "<option value='".$s['id']."'>".$s['nis']." - ".$s['nama_siswa']."</option>";
                    }
                    ?>
                </select>
            </div>

            <div>
                <label class="block text-xs font-bold text-emerald-700 uppercase tracking-widest mb-2 ml-1">Jumlah Bayar (Rp)</label>
                <div class="relative">
                    <span class="absolute left-4 top-3.5 text-gray-400 font-bold">Rp</span>
                    <input type="number" name="jumlah_bayar" class="w-full p-3.5 pl-12 border-2 border-gray-100 rounded-2xl focus:ring-4 focus:ring-emerald-50 focus:border-emerald-400 outline-none transition text-gray-700" placeholder="Contoh: 150000" required>
                </div>
            </div>
            
            <div class="flex flex-col gap-3 pt-4">
                <button type="submit" name="proses_bayar" class="w-full bg-emerald-600 text-white px-6 py-4 rounded-2xl font-bold hover:bg-emerald-700 shadow-lg shadow-emerald-100 transition-all transform active:scale-95 flex items-center justify-center gap-2">
                    <i class="fas fa-check-circle"></i> Bayar Sekarang
                </button>
                <a href="index.php" class="text-center text-gray-400 text-sm hover:text-emerald-600 transition font-medium">Batalkan Transaksi</a>
            </div>
        </form>
    </div>

    <footer class="text-center py-10 text-emerald-600/30 text-[10px] uppercase tracking-widest font-bold">
        &copy; 2025 SPP Digital System &bull; Payment Module
    </footer>
</body>
</html>