<?php
session_start();
include 'koneksi.php';
if (!isset($_SESSION['admin'])) { header("location:login.php"); exit(); }
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Daftar Siswa</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-blue-50 p-8">
    <div class="max-w-4xl mx-auto bg-white rounded-3xl shadow-lg p-6">
        <div class="flex justify-between items-center mb-6">
            <h2 class="text-2xl font-bold text-emerald-600">Daftar Siswa</h2>
          <a href="siswa.php" class="bg-white text-emerald-600 px-3 py-2 rounded-lg shadow-sm">Siswa</a>
        </div>
        <table class="w-full text-left border-collapse">
            <thead>
                <tr class="border-b text-gray-400 text-xs uppercase">
                    <th class="p-4">NIS</th>
                    <th class="p-4">Nama Siswa</th>
                    <th class="p-4">Kelas</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $q = mysqli_query($conn, "SELECT * FROM siswa ORDER BY nama_siswa ASC");
                while($s = mysqli_fetch_array($q)) {
                    echo "<tr class='border-b hover:bg-gray-50'>
                            <td class='p-4'>{$s['nis']}</td>
                            <td class='p-4 font-bold'>{$s['nama_siswa']}</td>
                            <td class='p-4'>{$s['kelas']}</td>
                          </tr>";
                }
                ?>
            </tbody>
        </table>
        <div class="mt-6">
            <a href="index.php" class="text-emerald-500 text-sm italic underline"> Kembali ke Dashboard</a>
        </div>
    </div>
</body>
</html>